using UnityEngine;

public class EnemyGenerator : MonoBehaviour
{
    [Header("敵のPrefab")]
    [SerializeField] private GameObject enemyPrefab;

    [Header("横スクロールのリミット位置")]
    [SerializeField] private float limit;

    [Header("敵の配置スパン")]
    [SerializeField] private float minSpan;
    [SerializeField] private float maxSpan;

    void Awake()
    {
        //初期位置設定
        Vector3 pos = new Vector3(10f, 0, 0);

        //設定したXのリミット位置まで敵を配置する
        while (pos.x <= limit)
		{
            //敵を生成
            GameObject obj = Instantiate(enemyPrefab, transform);

            //地面か空中のどちらに配置するか設定
            pos.y = 0.4f;
            if(Random.Range(0, 2) == 1)
            {
                pos.y = 2.0f;
            }
            obj.transform.position = pos;

            //横にずらす
            pos.x += Random.Range(minSpan, maxSpan);
		}
    }
}
