using System.Collections;
using System.Collections.Generic;
using UnityEngine;

#if STATE_LV2
public partial class Player : MonoBehaviour
{
	//ステータスをクラスで定義
	private static StateStanding stateStanding = new StateStanding();
	private static StateSquat stateSquat = new StateSquat();
	private static StateJump stateJump = new StateJump();
    private static StateDive stateDive = new StateDive();
    
    private PlayerStateBase currentState;

    //Player_Common.csからStartが呼ばれる
    void OnStart()
    {
	    //初期ステータス設定
        currentState = stateStanding;
        currentState.OnEnter(this, null);
    }

    //Player_Common.csからUpdateが呼ばれる
    void OnUpdate()
    {
	    //今のステータスのUpdateを呼ぶ
        currentState.OnUpdate(this);
    }

	// ステート変更
	private void ChangeState(PlayerStateBase nextState)
	{
		//今のステータスの終了処理をして、次のステータスの開始処理をする
		currentState.OnExit(this, nextState);
		nextState.OnEnter(this, currentState);
		currentState = nextState;
	}

	private void OnCollisionEnter(Collision collision)
	{
		//立ち判定
        ChangeState(stateStanding);
	}
}
#endif
