using System.Collections;
using System.Collections.Generic;
using UnityEngine;

#if STATE_LV2
public partial class Player
{
	public class StateSquat : PlayerStateBase
	{
		public override void OnEnter(Player owner, PlayerStateBase prevState)
		{
			owner.Squat();
		}

		public override void OnUpdate(Player owner)
		{
			if (!Input.GetKey(KeyCode.DownArrow))
			{
				owner.ChangeState(stateStanding);
			}
		}

		public override void OnExit(Player owner, PlayerStateBase nextState)
		{
			owner.EndSquat();
		}
	}
}
#endif