using System.Collections;
using System.Collections.Generic;
using UnityEngine;

#if STATE_LV1
public partial class Player : MonoBehaviour
{
    private enum State
    {
        Standing,   //通常
        Squat,      //しゃがみ
        Jump,       //ジャンプ
        Dive        //ダイブ
    };
    State PlayState;

    //Player_Common.csからStartが呼ばれる
    void OnStart()
    {
        PlayState = State.Standing;
    }

    //Player_Common.csからUpdateが呼ばれる
    void OnUpdate()
    {
        switch(PlayState)
        {
            case State.Standing:
                //座り判定
                if (Input.GetKey(KeyCode.DownArrow))
                {
                    Squat();
                    PlayState = State.Squat;
                }

                //ジャンプ判定
                if (Input.GetKey(KeyCode.Space))
                {
                    Jump();
                    PlayState = State.Jump;
                }
                break;

            case State.Squat:
                //立っている判定
                if (!Input.GetKey(KeyCode.DownArrow))
                {
                    EndSquat();
                    PlayState = State.Standing;
                }
                break;

            case State.Jump:
                //ダイブ判定
                if (Input.GetKey(KeyCode.DownArrow))
                {
                    Dive();
                    PlayState = State.Dive;
                }
                break;

            case State.Dive:
                break;
        }
    }

	private void OnCollisionEnter(Collision collision)
	{
        PlayState = State.Standing;
	}
}
#endif

