using UnityEngine;

// ステート以外の処理部分
public partial class Player : MonoBehaviour
{
    public bool IsDead;
    public float HP;

    [Header("スクロール速度")]
    [SerializeField] private float moveSpeed;

    [Header("死んだ時にRigidbodyに与える力")]
    [SerializeField] private Vector3 deathAddForce = Vector3.zero;
    [SerializeField] private Vector3 deathAddTorque = Vector3.zero;

    private Vector3 defaultScale;
    private Material materialInstance;
    private Rigidbody rb;

    private void Start()
    {
        //初期値設定、コンポーネント取得
        HP = 1.0f;
        defaultScale = transform.localScale;
        rb = GetComponent<Rigidbody>();
        materialInstance = GetComponent<MeshRenderer>().material;

        OnStart();
    }

	private void Update()
	{
        // 自動で右方向に移動
        transform.position += Vector3.right * moveSpeed * Time.deltaTime;

        OnUpdate();
    }

    //ジャンプ
    private void Jump()
    {
        rb.AddForce(Vector3.up * 7f, ForceMode.Impulse);
    }

    //素早く地面に接地
    private void AdjustGround()
    {
        var pos = transform.position;
        pos.y = transform.localScale.y * 0.5f;
        transform.position = pos;
    }

    //しゃがみ
    private void Squat()
    {
        transform.localScale = Vector3.one;
        AdjustGround();
    }

    //立つ
    private void EndSquat()
    {
        transform.localScale = defaultScale;
    }

    //ダイブ
    private void Dive()
    {
        rb.AddForce(Vector3.down * 14f, ForceMode.Impulse);
    }

    //敵と当たった時
    private void OnTriggerEnter(Collider other)
    {
        materialInstance.color = Color.red;
    }

    //敵と当たり続けている時
    private void OnTriggerStay(Collider other)
    {
        if (other.TryGetComponent(out Enemy enemy))
        {
            HP -= enemy.Damage * Time.deltaTime;

            if(HP <= 0)
            {
                DeathAction();
            }
        }
    }

    //敵と離れた時
    private void OnTriggerExit(Collider other)
    {
        materialInstance.color = Color.blue;
    }

	// 死亡した時に呼ばれる
	private void DeathAction()
	{
        IsDead = true;
        
		// 動作停止
		GetComponent<Collider>().enabled = false;

		// 吹っ飛ばす
		rb.constraints = RigidbodyConstraints.FreezePositionZ | RigidbodyConstraints.FreezeRotationX;
		rb.AddForce(deathAddForce, ForceMode.Impulse);
		rb.AddTorque(deathAddTorque, ForceMode.Impulse);
	}
}
